package org.msh.tb.export_rest.core;

import java.util.List;

/**
 * Created by rmemoria on 9/7/17.
 */
public interface BlockReader {

    List<String> getColumns();

    long getRecordCount();

    /**
     * Return the current record. If no record was read, the first one is read and returned
     *
     * @return the current record, or null if there is no record available
     */
    Record current();

    /**
     * Return the next record
     *
     * @return The next record or null if there is no next record
     */
    Record next();
}
